// Copyright 2023 Tomoyuki Watanabe
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#ifndef UTILITY_H
#define	UTILITY_H

#include <stdint.h>

#ifdef	__cplusplus
extern "C" {
#endif

uint8_t stoi16(int16_t* value, const char* str);
uint8_t stou8(uint8_t* value, const char* str);
uint8_t stou16(uint16_t* value, const char* str);
uint8_t stou24(__uint24* value, const char* str);
uint8_t htou32(uint32_t* value, const char* str);
uint8_t htou16(uint16_t* value, const char* str);
uint8_t htou8(uint8_t* value, const char* str);
uint8_t stobytes(uint8_t* buff, const uint8_t buff_len, const char* str, uint8_t* buff_count);
uint16_t stobytes2(uint8_t* buff, const uint16_t buff_len, const char* str, uint16_t* buff_count);
uint8_t u32tohs(char* buff, const uint32_t v);
uint8_t u32tohs2(char* buff, const uint32_t v, const uint8_t null_term);
uint8_t u24tohs(char* buff, const __uint24 v);
uint8_t u24tohs2(char* buff, const __uint24 v, const uint8_t null_term);
uint8_t u16tohs(char* buff, const uint16_t v);
uint8_t u16tohs2(char* buff, const uint16_t v, const uint8_t null_term);
uint8_t u12tohs(char* buff, const uint16_t v);
uint8_t u12tohs2(char* buff, const uint16_t v, const uint8_t null_term);
uint8_t u8tohs(char* buff, const uint8_t v);
uint8_t u8tohs2(char* buff, const uint8_t v, const uint8_t null_term);
uint8_t bytestos(char* des, const uint8_t* src, const uint8_t src_len);
uint8_t u32tos2(char* buff, const uint32_t v, const uint8_t digit, const uint8_t null_term);
uint8_t u32tos(char* buff, const uint32_t v);
uint8_t i32tos2(char* buff, const int32_t v, const uint8_t digit, const uint8_t null_term);
uint8_t i32tos(char* buff, const int32_t v);
uint8_t u24tos2(char* buff, const __uint24 v, const uint8_t digit, const uint8_t null_term);
uint8_t u24tos(char* buff, const __uint24 v);
uint8_t i24tos2(char* buff, const __int24 v, const uint8_t digit, const uint8_t null_term);
uint8_t i24tos(char* buff, const __int24 v);
uint8_t u16tos2(char* buff, const uint16_t v, const uint8_t digit, const uint8_t null_term);
uint8_t u16tos(char* buff, const uint16_t v);
uint8_t i16tos2(char* buff, const int16_t v, const uint8_t digit, const uint8_t null_term);
uint8_t i16tos(char* buff, const int16_t v);
uint8_t u8tos2(char* buff, const uint8_t v, const uint8_t digit, const uint8_t null_term);
uint8_t u8tos(char* buff, const uint8_t v);
uint8_t i8tos2(char* buff, const int8_t v, const uint8_t digit, const uint8_t null_term);
uint8_t i8tos(char* buff, const int8_t v);
uint8_t strcpy2(char* d, const char* s);
uint8_t strcontain(const char* base_str, const char* sub_str);
uint8_t calc_checksum(const void* bytes, uint8_t len);

#ifdef	__cplusplus
}
#endif

#endif	/* UTILITY_H */

