// Copyright 2023 Tomoyuki Watanabe
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#ifndef UART_H
#define	UART_H

#include <xc.h>
#include <stdint.h>

#ifdef	__cplusplus
extern "C" {
#endif

#define UART_SYNC   1
#define UART_ASYNC  0

void uart_init(void);
uint8_t uart_recv(uint8_t* buff, const uint8_t size);
uint8_t uart_send(const uint8_t* buff, const uint8_t size, const uint8_t sync);
void uart_putc(const char c);
void uart_putc_async(const char c);
void uart_print(const char* str);
void uart_print_endl(void);
void uart_print_endl_async(void);
void uart_print_bytes(const uint8_t* bytes, const uint8_t size);
void uart_print_hu32(const uint32_t v);
void uart_print_hu24(const __uint24 v);
void uart_print_hu16(const uint16_t v);
void uart_print_hu12(const uint16_t v);
void uart_print_hu8(const uint8_t v);
void uart_print_hu8_async(const uint8_t v);
void uart_print_u32(const uint32_t v);
void uart_print_u24(const __uint24 v);
void uart_print_u16(const uint16_t v);
void uart_print_u8(const uint8_t v);
void uart_print_i8(const int8_t v);

#ifdef	__cplusplus
}
#endif

#endif	/* UART_H */

