// Copyright 2023 Tomoyuki Watanabe
// 
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// 
//     http://www.apache.org/licenses/LICENSE-2.0
// 
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#ifndef SPI_H
#define	SPI_H

#include <xc.h>
#include <stdint.h>

#ifdef	__cplusplus
extern "C" {
#endif
    
void spic_init(void);
void spic_reset(void);
int8_t spic_get_cmd(uint8_t* cmd_id, void* param, const uint8_t param_len);
int8_t spic_set_res(const uint8_t res_id, const void* param, const uint8_t param_len);

#ifdef	__cplusplus
}
#endif

#endif	/* I2C_H */

