// Copyright 2023 Tomoyuki Watanabe
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#ifndef PWM_H
#define	PWM_H

#include <xc.h>
#include <stdint.h>

#define PWM_CH_CHG 0
#define PWM_CH_DSC 1

#define PWM_HIGH_OUT 1600
#define PWM_MAX_DUTY 1440 // 1600 * 0.9 = 1440

#ifdef	__cplusplus
extern "C" {
#endif

void pwm_init(void);
void pwm_set_duty(uint16_t duty);

#ifdef	__cplusplus
}
#endif

#endif	/* PWM_H */

