// Copyright 2023 Tomoyuki Watanabe
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#include "pwm.h"

void pwm_init(void)
{
    // Bits 3:0 ? CLK[3:0]: 0010 FOSC
    PWM1CLK = 0x02;

    PWM1PR = 1599; // 64MHz / 40kHz = 1600

    // Bit 6 ? POL1: 1 PWMx_SaP1_out is low true
    // Bits 2:0 ? MODE[2:0]: 000 Left Aligned mode
    PWM1S1CFG = 0x40;

    PWM1S1P1 = 0;

    // Bit 7 ? EN?PWM Module Enable: 1 PWM module is enabled
    PWM1CON = 0x80;

    PWMLOADbits.MPWM1LD = 1;
    PWMENbits.MPWM1EN = 1;
}

void pwm_set_duty(uint16_t duty)
{
    PWM1S1P1 = duty;
    PWMLOADbits.MPWM1LD = 1;
}
