// Copyright 2023 Tomoyuki Watanabe
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#include "led.h"
#include "tmr.h"

#define LED_TICK tmr_get_tick8(1) // 256ms unit, 0 - 65,280ms
#define LED_PORT (LATCbits.LATC1)

#define LED_ST_OFF1 0 // 1 count, 0.256sec
#define LED_ST_OFF2 1 // 2 count, 0.512sec
#define LED_ST_OFF4 2 // 4 count, 1.024sec
#define LED_ST_ON1  3 // 1 count, 0.256sec
#define LED_ST_ON2  4 // 2 count, 0.512sec

uint8_t led_prev_tick;
uint8_t led_state;
uint8_t led_blink_count;
uint8_t led_cur_blink_count;
uint8_t led_mode = LED_MD_OFF;

void led_init(void)
{

}

void led_set_mode(uint8_t mode, uint8_t blink_count)
{
    led_mode = mode;
    led_blink_count = blink_count;
    switch(mode)
    {
    case LED_MD_ON:
        LED_PORT = 1;
        break;
    case LED_MD_BLINK:
        led_state = LED_ST_OFF1;
        led_prev_tick = LED_TICK;
        LED_PORT = 0;
        break;
    case LED_MD_N_BLINK:
        led_state = LED_ST_OFF4;
        led_prev_tick = LED_TICK;
        LED_PORT = 0;
        led_cur_blink_count = 0;
        break;
    default: // LED_MD_OFF
        LED_PORT = 0;
        break;
    }
}

void led_update(void)
{
    uint8_t tick = LED_TICK - led_prev_tick;
    if(led_mode == LED_MD_BLINK)
    {
        if(led_state == LED_ST_OFF1)
        {
            if(tick >= 1)
            {
                led_state = LED_ST_ON1;
                led_prev_tick = LED_TICK;
                LED_PORT = 1;
            }
        }
        else
        {
            if(tick >= 1)
            {
                led_state = LED_ST_OFF1;
                led_prev_tick = LED_TICK;
                LED_PORT = 0;
            }
        }
    }
    else if(led_mode == LED_MD_N_BLINK)
    {
        if(led_state == LED_ST_OFF4)
        {
            if(tick >= 4)
            {
                led_state = LED_ST_ON1;
                led_prev_tick = LED_TICK;
                LED_PORT = 1;
                led_cur_blink_count++;
            }
        }
        else if(led_state == LED_ST_ON1)
        {
            if(tick >= 1)
            {
                if(led_cur_blink_count >= led_blink_count)
                {
                    led_state = LED_ST_OFF4;
                    led_prev_tick = LED_TICK;
                    LED_PORT = 0;
                    led_cur_blink_count = 0;
                }
                else
                {
                    led_state = LED_ST_OFF1;
                    led_prev_tick = LED_TICK;
                    LED_PORT = 0;
                }
            }
        }
        else //LED_ST_OFF2
        {
            if(tick >= 1)
            {
                led_state = LED_ST_ON1;
                led_prev_tick = LED_TICK;
                LED_PORT = 1;
                led_cur_blink_count++;
            }
        }
    }
}
