// Copyright 2023 Tomoyuki Watanabe
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#include "fvr.h"

void fvr_init(void)
{
    // Bit 7 - FVREN: 1 Fixed Voltage Reference is enabled
    // Bits 3:2 - CDAFVR[1:0]: 01 FVR Buffer 2 Gain is 1x, (1.024V)
    // Bits 1:0 - ADFVR[1:0]: 11 FVR Buffer 1 Gain is 4x, (4.096V)
    // 1000 0111
    FVRCON = 0x87;

    // Wait for ready
    while(!FVRCONbits.FVRRDY) {}
}
