// Copyright 2023 Tomoyuki Watanabe
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#include "dac.h"

void dac_init(void)
{
    // Bit 7 - EN: 1 DAC is enabled
    // Bits 5:4 - OE[1:0]: 10 DACxOUT is enabled on pin RA2 only
    // Bits 3:2 - PSS[1:0]: 10 FVR Buffer 2
    // Bit 0 - NSS: 0 VSS
    // 1010 1000
    DAC1CON = 0xa8;
}

void dac_set_step(uint8_t step)
{
    DAC1DATL = step;
    LATCbits.LATC0 = (step > 0) ? 0: 1;
}
