// Copyright 2023 Tomoyuki Watanabe
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#ifndef CHGV_H
#define	CHGV_H

#include "chgv_if.h"
#include <stdint.h>

#ifdef	__cplusplus
extern "C" {
#endif

#define CHGV_STAUS_NUM 8

extern chgv_config_t chgv_config;
extern chgv_status_t chgv_status[CHGV_STAUS_NUM];
extern uint8_t chgv_status_cnt;
extern uint8_t chgv_status_top;

#define DEV_ID                 (chgv_config.dev_id)
#define OPA_OFFSET             (chgv_config.opa_offset)
#define Q_CHG_MIN_VOL          (chgv_config.q_chg_min_vol)
#define N_CHG_FIN_VOL          (chgv_config.n_chg_fin_vol)
#define BAT_MIN_VOL            (chgv_config.bat_min_vol)
#define MIN_CHG_STA_VOL        (chgv_config.min_chg_sta_vol)
#define BAT_MAX_VOL            (chgv_config.bat_max_vol)
#define BAT_CAP                (chgv_config.bat_cap)
#define Q_CHG_TGT_VOL          (chgv_config.q_chg_tgt_vol)
#define N_CHG_TGT_VOL          (chgv_config.n_chg_tgt_vol)
#define DSC_TGT_STEP           (chgv_config.dsc_tgt_step)
#define DSC_END_TGT_STEP       (chgv_config.dsc_end_tgt_step)
#define DSC_END_VOL            (chgv_config.dsc_end_vol)
#define Q_CHG_DET_VOL          (chgv_config.q_chg_det_vol)
#define N_CHG_TIME             (chgv_config.n_chg_time)
#define Q_CHG_TIME             (chgv_config.q_chg_time)
#define Q_CHG_NO_CHK_DUR       (chgv_config.q_chg_no_chk_dur)
#define Q_CHG_NO_CHK_VOL       (chgv_config.q_chg_no_chk_vol)
#define IDLE_MES               (chgv_config.idle_mes)
#define DSC_ONLY               (chgv_config.dsc_only)
#define CFG_SIGNATURE          (chgv_config.signature)

void chgv_cal_tgt_vol(void);
void chgv_init_config(void);
int8_t chgv_load_config(void);
int8_t chgv_save_config(void);
void chgv_print_config(void);

void chgv_cal_tgt_vol(void);
void chgv_init_config(void);
void chgv_update_cfg_checksum(void);
int8_t chgv_load_config(void);
int8_t chgv_save_config(void);
void chgv_print_config(void);
void chgv_print_status(const chgv_status_t* status, uint8_t value_only);
void chgv_write_status(void);

#ifdef	__cplusplus
}
#endif

#endif	/* VAR_H */
