// Copyright 2023 Tomoyuki Watanabe
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#ifndef ADC_H
#define	ADC_H

#include <xc.h>
#include <stdint.h>

#ifdef	__cplusplus
extern "C" {
#endif

// order is important
#define ADC_MD_Q_CHG     0
#define ADC_MD_Q_CHG_TST 1
#define ADC_MD_N_CHG     2
#define ADC_MD_N_CHG_TST 3
#define ADC_MD_OP_VOL    4
#define ADC_MD_OP_VOL2   5
#define ADC_MD_DSC       6
#define ADC_MD_OFF_CAL   7

#define ADC_MD_PWM_ENABLED ADC_MD_N_CHG_TST

#define ADC_RST_NONE 0
#define ADC_RST_CMP  1
#define ADC_RST_ERR  2

#define ADC_ERR_NONE     0
#define ADC_ERR_OVER_CUR 1

#define ADC_CH_CNT 2
extern uint16_t adc_val[ADC_CH_CNT];
extern uint16_t adc_tgt_vol;
extern uint16_t adc_tst_pwm_duty;
extern uint8_t adc_result;
extern uint8_t adc_err;

void adc_init(void);
void adc_start(uint8_t mode);
void adc_stop(void);

#ifdef	__cplusplus
}
#endif

#endif	/* ADC_H */

