// Copyright 2023 Tomoyuki Watanabe
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#ifndef UART_UTIL_H
#define	UART_UTIL_H

#ifdef	__cplusplus
extern "C" {
#endif
    
#include <xc.h>

#define UART_DEV_DBG 0
#define UART_DEV_CMD 1
#define UART_DEV_NUM 2
    
void uart_putc(const uint8_t dev, const char c);
void uart_putc_async(const uint8_t dev, const char c);
void uart_print(const uint8_t dev, const char* str);
void uart_print_endl(const uint8_t dev);
void uart_print_endl_async(const uint8_t dev);
void uart_print_bytes(const uint8_t dev, const uint8_t* bytes, const uint16_t size);
void uart_print_hu32(const uint8_t dev, const uint32_t v);
void uart_print_hu24(const uint8_t dev, const __uint24 v);
void uart_print_hu16(const uint8_t dev, const uint16_t v);
void uart_print_hu12(const uint8_t dev, const uint16_t v);
void uart_print_hu8(const uint8_t dev, const uint8_t v);
void uart_print_u32(const uint8_t dev, const uint32_t v);
void uart_print_u24(const uint8_t dev, const __uint24 v);
void uart_print_u16(const uint8_t dev, const uint16_t v);
void uart_print_u8(const uint8_t dev, const uint8_t v);
void uart_print_hu8_async(const uint8_t dev, const uint8_t v);
void uart_print_i8(const uint8_t dev, const int8_t v);

#ifdef	__cplusplus
}
#endif

#endif	/* UART_UTIL_H */

