#include "uart1.h"
#include "uart2.h"
#include "utility.h"
#include "uart_util.h"

#define PRINT_BUF_SIZE 9 // hu32 max digit is 8
char uart_print_buff[PRINT_BUF_SIZE];

void uart_putc(const uint8_t dev, const char c)
{
    if(dev == 0) uart1_send((const uint8_t*)&c, 1, 1);
    else uart2_send((const uint8_t*)&c, 1, 1);
}

void uart_putc_async(const uint8_t dev, const char c)
{
    if(dev == 0) uart1_send((const uint8_t*)&c, 1, 0);
    else  uart2_send((const uint8_t*)&c, 1, 0);
}

void uart_print(const uint8_t dev, const char* str)
{
    uint8_t i;
    for(i = 0; str[i]; i++) {}
    if(dev == 0) uart1_send((const uint8_t*)str, i, 1);
    else uart2_send((const uint8_t*)str, i, 1);
}

void uart_print_endl(const uint8_t dev)
{
    const char* endl = "\r\n";
    if(dev == 0) uart1_send((const uint8_t*)endl, 2, 1);
    else uart2_send((const uint8_t*)endl, 2, 1);
}

void uart_print_endl_async(const uint8_t dev)
{
    const char* endl = "\r\n";
    if(dev == 0) uart1_send((const uint8_t*)endl, 2, 0);
    else uart2_send((const uint8_t*)endl, 2, 0);
}

void uart_print_bytes(const uint8_t dev, const uint8_t* bytes, const uint16_t size)
{
    uint16_t i;
    for(i = 0; i < size; i++)
    {
        u8tohs(uart_print_buff, bytes[i]);
        if(dev == 0) uart1_send((uint8_t*)uart_print_buff, 2, 1);
        else uart2_send((uint8_t*)uart_print_buff, 2, 1);
    }
}

void uart_print_hu32(const uint8_t dev, const uint32_t v)
{
    uint8_t i;
    i = u32tohs(uart_print_buff, v);
    if(dev == 0) uart1_send((uint8_t*)uart_print_buff, i, 1);
    else uart2_send((uint8_t*)uart_print_buff, i, 1);
}

void uart_print_hu24(const uint8_t dev, const __uint24 v)
{
    uint8_t i;
    i = u24tohs(uart_print_buff, v);
    if(dev == 0) uart1_send((uint8_t*)uart_print_buff, i, 1);
    else uart2_send((uint8_t*)uart_print_buff, i, 1);
}

void uart_print_hu16(const uint8_t dev, const uint16_t v)
{
    uint8_t i;
    i = u16tohs(uart_print_buff, v);
    if(dev == 0) uart1_send((uint8_t*)uart_print_buff, i, 1);
    else uart2_send((uint8_t*)uart_print_buff, i, 1);
}

void uart_print_hu12(const uint8_t dev, const uint16_t v)
{
    uint8_t i;
    i = u12tohs(uart_print_buff, v);
    if(dev == 0) uart1_send((uint8_t*)uart_print_buff, i, 1);
    else uart2_send((uint8_t*)uart_print_buff, i, 1);
}

void uart_print_hu8(const uint8_t dev, const uint8_t v)
{
    uint8_t i;
    i = u8tohs(uart_print_buff, v);
    if(dev == 0) uart1_send((uint8_t*)uart_print_buff, i, 1);
    else uart2_send((uint8_t*)uart_print_buff, i, 1);
}

void uart_print_hu8_async(const uint8_t dev, const uint8_t v)
{
    uint8_t i;
    i = u8tohs(uart_print_buff, v);
    if(dev == 0) uart1_send((uint8_t*)uart_print_buff, i, 0);
    else uart2_send((uint8_t*)uart_print_buff, i, 0);
}

void uart_print_u32(const uint8_t dev, const uint32_t v)
{
    uint8_t i;
    i = u32tos(uart_print_buff, v);
    if(dev == 0) uart1_send((uint8_t*)uart_print_buff, i, 1);
    else uart2_send((uint8_t*)uart_print_buff, i, 1);
}

void uart_print_u24(const uint8_t dev, const __uint24 v)
{
    uint8_t i;
    i = u24tos(uart_print_buff, v);
    if(dev == 0) uart1_send((uint8_t*)uart_print_buff, i, 1);
    else uart2_send((uint8_t*)uart_print_buff, i, 1);
}

void uart_print_u16(const uint8_t dev, const uint16_t v)
{
    uint8_t i;
    i = u16tos(uart_print_buff, v);
    if(dev == 0) uart1_send((uint8_t*)uart_print_buff, i, 1);
    else uart2_send((uint8_t*)uart_print_buff, i, 1);
}

void uart_print_u8(const uint8_t dev, const uint8_t v)
{
    uint8_t i;
    i = u8tos(uart_print_buff, v);
    if(dev == 0) uart1_send((uint8_t*)uart_print_buff, i, 1);
    else uart2_send((uint8_t*)uart_print_buff, i, 1);
}

void uart_print_i8(const uint8_t dev, const int8_t v)
{
    uint8_t i;
    i = i8tos(uart_print_buff, v);
    if(dev == 0) uart1_send((uint8_t*)uart_print_buff, i, 1);
    else uart2_send((uint8_t*)uart_print_buff, i, 1);
}
