// Copyright 2023 Tomoyuki Watanabe
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#ifndef UART2_H
#define	UART2_H

#include <xc.h>
#include <stdint.h>

#ifdef	__cplusplus
extern "C" {
#endif

#define UART2_SYNC   1
#define UART2_ASYNC  0

void uart2_init(void);
void uart2_flush_rx_buf(void);
uint16_t uart2_send(const uint8_t* buff, const uint16_t size, const uint8_t sync);
uint8_t uart2_recv(uint8_t* buff, const uint8_t size);
void uart2_rx1_int_handler(void);
void uart2_tx1_int_handler(void);
void uart2_rx2_int_handler(void);
void uart2_tx2_int_handler(void);

#ifdef	__cplusplus
}
#endif

#endif	/* UART2_H */

