// Copyright 2023 Tomoyuki Watanabe
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#ifndef SWITCH_H
#define	SWITCH_H

#include <stdint.h>

#ifdef	__cplusplus
extern "C" {
#endif

typedef union sw_request_
{
    uint8_t b;
    struct
    {
        uint8_t startstop_press : 1;
        uint8_t startstop_long_press : 1;
        uint8_t set_press : 1;
        uint8_t set_long_press : 1;
        uint8_t down_press : 1;
        uint8_t down_long_press : 1;
        uint8_t return_press : 1;
        uint8_t return_long_press : 1;
    } bits;
} sw_request_t;
extern sw_request_t sw_req;

void sw_init(void);
void sw_update(void);

#ifdef	__cplusplus
}
#endif

#endif	/* SWITCH_H */

