#ifndef _SPI_H
#define _SPI_H

#include <xc.h>
#include <stdint.h>

#ifdef __cplusplus
extern "C" {
#endif

void spi_init(void);
void spi_transfer(uint8_t* tx_buf, uint8_t* rx_buf, uint16_t length);
void spi_receive(uint8_t* rx_buf, uint16_t length);
void spi_send(uint8_t* tx_buf, uint16_t length);
void spi_send_repeat(uint8_t byte, uint16_t count);
void spi_switch_baud_rate(const uint8_t high_speed);
uint8_t spi_transfer_byte(const uint8_t byte);
inline void spi_set_cs(const uint8_t cs);

#ifdef __cplusplus
}
#endif

#endif /* _SPI_H */

