// Copyright 2023 Tomoyuki Watanabe
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#ifndef NVM_H
#define	NVM_H

#include <xc.h>

#ifdef	__cplusplus
extern "C" {
#endif

void nvm_read(uint8_t* buff, uint8_t offset, int16_t len);
int16_t nvm_verify(const uint8_t* buff, uint8_t offset, int16_t len);
int16_t nvm_write(const uint8_t* buff, uint8_t offset, int16_t len);

#ifdef	__cplusplus
}
#endif

#endif	/* NVM_H */

