#include "nvm.h"

#define DFM_ADDR          0x380000
#define RETRY_COUNT_LIMIT 2

void nvm_read(uint8_t* buff, uint8_t offset, int16_t len)
{
    int16_t i;

    NVMADR = DFM_ADDR + offset;
    NVMCON1bits.CMD = 0x01; // Read and Post Increment
    for(i = 0; i < len; i++)
    {
        NVMCON0bits.GO = 1;
        while (NVMCON0bits.GO) {}
        buff[i] = NVMDATL;
    }
}

int16_t nvm_verify(const uint8_t* buff, uint8_t offset, int16_t len)
{
    int16_t i;

    NVMADR = DFM_ADDR + offset;
    NVMCON1bits.CMD = 0x01; // Read and Post Increment
    for(i = 0; i < len; i++)
    {
        NVMCON0bits.GO = 1;
        while (NVMCON0bits.GO) {}
        if(buff[i] != NVMDATL)
            break;
    }

    return i;
}

int16_t nvm_write(const uint8_t* buff, uint8_t offset, int16_t len)
{
    int16_t i;

    NVMADR = DFM_ADDR + offset;
    NVMCON1bits.CMD = 0x04; // Write and Post Increment
    for(i = 0; i < len; i++)
    {
        uint8_t retry_count = 0;
        do
        {
            NVMCON1bits.WRERR = 0;
            NVMDATL = buff[i];
            INTCON0bits.GIE = 0;
            NVMLOCK = 0x55;
            NVMLOCK = 0xAA;
            NVMCON0bits.GO = 1;
            while (NVMCON0bits.GO) {}
            INTCON0bits.GIE = 1;
        } while (NVMCON1bits.WRERR && retry_count++ < RETRY_COUNT_LIMIT);
        if(NVMCON1bits.WRERR)
        {
            return -1;
        }
    }

    return i;
}
