// Copyright 2023 Tomoyuki Watanabe
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#ifndef LED_H
#define	LED_H

#include <xc.h>
#include <stdint.h>

#ifdef	__cplusplus
extern "C" {
#endif

#define LED_MD_OFF     0
#define LED_MD_ON      1
#define LED_MD_BLINK   2
#define LED_MD_N_BLINK 3

#define LED_PORT_SD    0
#define LED_PORT_STATE 1
#define LED_PORT_NUM   2

void led_init(void);
void led_set_mode(uint8_t port, uint8_t mode, uint8_t blink_count);
void led_update(void);

#ifdef	__cplusplus
}
#endif

#endif	/* LED_H */

