// Copyright 2023 Tomoyuki Watanabe
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#include "lcd.h"
#include "tmr.h"
#include "i2ch.h"

#define _XTAL_FREQ     32000000
#define LCD_DEV_ADDR   0x3e // AQM1602Y-RN-GBW
#define CHEKC_DURATION 100 // ms

uint16_t lcd_update_tick;
char lcd_data_buf[2][16];
uint8_t lcd_com_buf[2];
uint8_t lcd_update_flag = 0;
uint8_t lcd_off = 0;

void lcd_init(void)
{
    __delay_ms(100);
    lcd_com_buf[0] = 0x00; // command
    lcd_com_buf[1] = 0x38; // function set, interface data 8bit, instruction table = 0
    i2ch_write(lcd_com_buf, LCD_DEV_ADDR, 2);
    __delay_us(30);
    lcd_com_buf[1] = 0x39; // function set, interface data 8bit, instruction table = 1
    i2ch_write(lcd_com_buf, LCD_DEV_ADDR, 2);
    __delay_us(30);
    lcd_com_buf[1] = 0x14; // internal OSC frequency
    i2ch_write(lcd_com_buf, LCD_DEV_ADDR, 2);
    __delay_us(30);
    lcd_com_buf[1] = 0x73; // contrast set
    i2ch_write(lcd_com_buf, LCD_DEV_ADDR, 2);
    __delay_us(30);
    //lcd_com_buf[1] = 0x52; // power, ICON control(Bon=0 if VCC=5V), contrast set
    lcd_com_buf[1] = 0x56; // power, ICON control(Bon=1 if VCC=3.3V), contrast set
    i2ch_write(lcd_com_buf, LCD_DEV_ADDR, 2);
    __delay_us(30);
    lcd_com_buf[1] = 0x6c; // follower set
    i2ch_write(lcd_com_buf, LCD_DEV_ADDR, 2);
    __delay_ms(300);
    lcd_com_buf[1] = 0x38; // function set, interface data 8bit, instruction table = 0
    i2ch_write(lcd_com_buf, LCD_DEV_ADDR, 2);
    __delay_us(30);
    lcd_com_buf[1] = 0x01; // clear display
    i2ch_write(lcd_com_buf, LCD_DEV_ADDR, 2);
    __delay_us(1000);
    lcd_com_buf[1] = 0x0c; // display on/off control
    i2ch_write(lcd_com_buf, LCD_DEV_ADDR, 2);
    __delay_us(30);
}

void lcd_update(void)
{
    if(((uint16_t)tmr_get_tick() - lcd_update_tick) > CHEKC_DURATION)
    {
        if(lcd_update_flag && !lcd_off)
        {
            uint8_t i;

            lcd_update_flag = 0;
            lcd_com_buf[0] = 0x00; // command
            lcd_com_buf[1] = 0x80; // DRAM address 0x00
            i2ch_write(lcd_com_buf, LCD_DEV_ADDR, 2);
            __delay_us(20);
            for(i = 0; i < sizeof(lcd_data_buf[0]); i++)
            {
                lcd_com_buf[0] = 0x40; // data
                lcd_com_buf[1] = lcd_data_buf[0][i];
                i2ch_write(lcd_com_buf, LCD_DEV_ADDR, 2);
                __delay_us(30);
            }

            lcd_com_buf[0] = 0x00; // command
            lcd_com_buf[1] = 0xc0; // DRAM address 0x00
            i2ch_write(lcd_com_buf, LCD_DEV_ADDR, 2);
            __delay_us(20);
            for(i = 0; i < sizeof(lcd_data_buf[1]); i++)
            {
                lcd_com_buf[0] = 0x40; // data
                lcd_com_buf[1] = lcd_data_buf[1][i];
                i2ch_write(lcd_com_buf, LCD_DEV_ADDR, 2);
                __delay_us(30);
            }
        }
        lcd_update_tick = (uint16_t)tmr_get_tick();
    }
}
