// Copyright 2023 Tomoyuki Watanabe
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#ifndef I2C_H
#define	I2C_H

#include <xc.h>
#include <stdint.h>

#ifdef	__cplusplus
extern "C" {
#endif

void i2ch_init(void);
int8_t i2ch_write(uint8_t* buf, const uint8_t dev_addr, const uint8_t len);
int8_t i2ch_read(uint8_t* buf, const uint8_t dev_addr, const uint8_t len);

#ifdef	__cplusplus
}
#endif

#endif	/* I2C_H */

