// Copyright 2023 Tomoyuki Watanabe
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#ifndef CHGV_IF_H
#define	CHGV_IF_H

#include <stdint.h>
#include <stddef.h>
#include <xc.h>

#ifdef	__cplusplus
extern "C" {
#endif

typedef struct chgv_status_
{
    uint32_t tick;
    uint16_t chgdsc_bat_vol;
    uint16_t chgdsc_current;
    uint16_t open_bat_vol;
    uint16_t prev_chgdsc_bat_vol;
    uint8_t err_code;
    uint8_t prev_state;
    uint8_t state;
} chgv_status_t;

typedef struct chgv_config_
{
    __uint24 n_chg_time;
    uint8_t opa_offset;
    __uint24 q_chg_time;
    uint8_t dsc_only;
    uint16_t bat_cap;
    uint16_t bat_max_vol;
    uint16_t bat_min_vol;
    uint16_t dsc_end_vol;
    uint16_t min_chg_sta_vol;
    uint16_t n_chg_fin_vol;
    uint16_t n_chg_tgt_vol;
    uint16_t q_chg_det_vol;
    uint16_t q_chg_min_vol;
    uint16_t q_chg_no_chk_dur;
    uint16_t q_chg_no_chk_vol;
    uint16_t q_chg_tgt_vol;
    uint8_t dsc_tgt_step;
    uint8_t dsc_end_tgt_step;
    uint8_t idle_mes;
    uint8_t signature;
} chgv_config_t;

#define CHGV_STA_SIZE sizeof(chgv_status_t)
#define CHGV_CFG_SIZE sizeof(chgv_config_t)

#define CHGV_CFG_SIGNATURE_CONST 0x01

#define CHGV_ST_INIT           0
#define CHGV_ST_INIT_MES       1
#define CHGV_ST_CHK            2
#define CHGV_ST_DSC            3
#define CHGV_ST_DSC_MES        4
#define CHGV_ST_N_CHG          5
#define CHGV_ST_N_VOL_MES      6
#define CHGV_ST_Q_CHG          7
#define CHGV_ST_Q_VOL_MES      8
#define CHGV_ST_FIN            9
#define CHGV_ST_FIN_MES       10
#define CHGV_ST_ERR           11
#define CHGV_ST_N_CHG_VOL_TST 12
#define CHGV_ST_Q_CHG_VOL_TST 13
#define CHGV_ST_N_CHG_TST     14
#define CHGV_ST_N_VOL_MES_TST 15
#define CHGV_ST_Q_CHG_TST     16
#define CHGV_ST_Q_VOL_MES_TST 17
#define CHGV_ST_DSC_TST       18
#define CHGV_ST_OFF_CAL       19
#define CHGV_ST_VOL_MES_TST   20
#define CHGV_ST_NUM           21

#define CHGV_ERR_NONE         0
#define CHGV_ERR_BAT_MIN_VOL  2
#define CHGV_ERR_SHORT        3
#define CHGV_ERR_OPEN         4
#define CHGV_ERR_CHG_DUR      5
#define CHGV_ERR_OVER_CUR     6

#define CHGV_STATUS_STR_LEN   43

#ifdef	__cplusplus
}
#endif

#endif	/* CHGV_IF_H */