// Copyright 2023 Tomoyuki Watanabe
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#ifndef CHGV_H
#define	CHGV_H

#include "chgv_if.h"
#include <stdint.h>

#ifdef	__cplusplus
extern "C" {
#endif

#define CHGV_MAX_NOF_SLOTS 4
extern chgv_status_t chgv_status[CHGV_MAX_NOF_SLOTS];
extern uint16_t chgv_bat_cap[CHGV_MAX_NOF_SLOTS];
extern __uint24 chgv_n_chg_time[CHGV_MAX_NOF_SLOTS];
extern const char chgv_st_char[CHGV_ST_NUM];

void chgv_set_com_slot(uint8_t slot);
int8_t chgv_read_config_u8(uint8_t* value, const char* var_name);
int8_t chgv_read_config_u16(uint16_t* value, const char* var_name);
int8_t chgv_read_config_u24(__uint24* value, const char* var_name);
int8_t chgv_write_config_u8(const char* var_name, uint8_t value);
int8_t chgv_write_config_u16(const char* var_name, uint16_t value);
int8_t chgv_write_config_u24(const char* var_name, __uint24 value);
int8_t chgv_read_config(uint8_t slot);
int8_t chgv_write_config(uint8_t slot);
int8_t chgv_read_status(uint8_t slot, void (*read_callback)(uint8_t slot, char* status_str));
int8_t chgv_save_config(uint8_t slot);
int8_t chgv_start(uint8_t slot);
int8_t chgv_reset(uint8_t slot);
int8_t chgv_set_status(uint8_t slot, const char* status_str);
const char* chgv_st_text(uint8_t status);
const char* chgv_err_text(uint8_t err_code);

#ifdef	__cplusplus
}
#endif

#endif	/* CHGV_H */
