﻿using System;
using System.Collections.Generic;
using System.Drawing.Printing;
using System.Text;

namespace SDR
{
    class JjyDecoder
    {
        int lowCount;
        int highCount;
        int prevValue;
        int margin;

        public JjyDecoder()
        {
            lowCount = -1;
            highCount = -1;
            prevValue = 0;
            margin = 16 * 100; // 100ms
        }
        public int Decode(short[] real, out int lowCount_, out int highCount_)
        {
            int code = -1;
            lowCount_ = 0;
            highCount_ = 0;
            for (int i = 0; i < 1024; i++)
            {
                int curValue = real[i];
                if (prevValue != curValue)
                {
                    if (curValue > 0)
                    {
                        if(highCount > 0 && lowCount > 0)
                        {
                            if ((16000 - margin) <= (lowCount + highCount) &&
                                (lowCount + highCount) <= (16000 + margin))
                            {
                                if((16 * 200 - margin) <= highCount && highCount <= (16 * 200 + margin))
                                {
                                    code = 2;
                                }
                                else if ((16 * 500 - margin) <= highCount && highCount <= (16 * 500 + margin))
                                {
                                    code = 1;
                                }
                                else if ((16 * 800 - margin) <= highCount && highCount <= (16 * 800 + margin))
                                {
                                    code = 0;
                                }
                                else
                                {
                                    code = 3;
                                }
                            }
                            else
                            {
                                code = 3;
                            }
                            lowCount_ = lowCount;
                            highCount_ = highCount;
                        }
                        highCount = 1;
                    }
                    else
                    {
                        lowCount = 1;
                    }
                    prevValue = curValue;
                }
                else
                {
                    if (curValue > 0)
                    {
                        highCount++;
                    }
                    else
                    {
                        lowCount++;
                    }
                }
            }

            return code;
        }
    }
}
