﻿using System;
using System.Collections.Generic;
using System.Text;

namespace SDR
{
    public static class F16Math
    {
        // 4 * theta
        static short[] cordicThetaTable = new short[]
        {
            32767,
            19344,
            10220,
            5188,
            2604,
            1303,
            651,
            325,
            162,
            81,
            40,
            20,
            10,
            5,
            2,
            1
        };
        static short cordicNormScale = 19898;

        static F16Math()
        {

        }

        static public short Mul(short a, short b)
        {
            return (short)(((int)a * (int)b) >> 15);
        }

        static public int Div(short a, short b)
        {
            int c = (((int)a << 15) / b);
            return c;
        }

        static public short ToF16(double a)
        {
            return (short)(Math.Min(Math.Max(a, -1), 0.99996948) * 32768 + 0.5);
        }

        static public void CompMul(short r0, short i0, short r1, short i1, out short r2, out short i2)
        {
            r2 = (short)(((int)r0 * r1 - (int)i0 * i1) >> 15);
            i2 = (short)(((int)r0 * i1 + (int)i0 * r1) >> 15);
        }

        static public short Atan2(short x, short y)
        {
            if (x < -32767) x = -32767;
            if (y < -32767) y = -32767;
            int quadrantIndex = 0;
            if (x == 0)
            {
                if(y >= 0)
                {
                    return (32768 / 2);
                }
                else
                {
                    return -(32768 / 2);
                }
            }
            else if (x > 0)
            {
                if (y == 0)
                {
                    return 0;
                }
                else if (y > 0)
                {
                    // quadrant #1
                }
                else
                {
                    // quadrant #4
                    short tmp = x;
                    x = (short)-y;
                    y = tmp;
                    quadrantIndex = 3;
                }
            }
            else
            {
                if (y == 0)
                {
                    return -32768;
                }
                else if (y > 0)
                {
                    // quadrant #2
                    short tmp = x;
                    x = y;
                    y = (short)-tmp;
                    quadrantIndex = 1;
                }
                else
                {
                    // quadrant #3
                    x = (short)-x;
                    y = (short)-y;
                    quadrantIndex = 2;
                }
            }
            int acca = cordicNormScale * x;
            int accb = cordicNormScale * y;
            int theta0 = 32767 * 2;
            for (int i = 0; i < cordicThetaTable.Length; i++)
            {
                if (accb >= 0)
                {
                    int tmp = acca;
                    acca += (accb >> i);
                    accb -= (tmp >> i);
                    theta0 += cordicThetaTable[i];
                }
                else
                {
                    int tmp = acca;
                    acca -= (accb >> i);
                    accb += (tmp >> i);
                    theta0 -= cordicThetaTable[i];
                }
            }
            short theta = (short)(16384 - (short)(theta0 >> 2));
            switch(quadrantIndex)
            {
                case 0:
                    break;
                case 1:
                    theta += 32768 / 4;
                    break;
                case 2:
                    theta -= 32768 / 2;
                    break;
                default: // 3:
                    theta -= 32768 / 4;
                    break;
            }

            return theta;
        }

        // x and y must be less than 32717 / sqrt(2)
        static public short Norm(short x, short y)
        {
            if (x < -32767) x = -32767;
            if (y < -32767) y = -32767;
            if (x == 0)
            {
                return (y >= 0) ? y : (short)-y;
            }
            else if(x > 0)
            {
                if (y == 0)
                {
                    return x;
                }
                else if (y > 0)
                {
                    // quadrant #1
                }
                else
                {
                    // quadrant #4
                    short tmp = x;
                    x = (short)-y;
                    y = tmp;
                }
            }
            else
            {
                if (y == 0)
                {
                    return (x >= 0) ? x : (short)-x;
                }
                else if (y > 0)
                {
                    // quadrant #2
                    short tmp = x;
                    x = y;
                    y = (short)-tmp;
               }
                else
                {
                    // quadrant #3
                    x = (short)-x;
                    y = (short)-y;
                }
            }
            int acca = cordicNormScale * x;
            int accb = cordicNormScale * y;
            for (int i = 0; i < cordicThetaTable.Length; i++)
            {
                if(accb >= 0)
                {
                    int tmp = acca;
                    acca += (accb >> i);
                    accb -= (tmp >> i);
                }
                else
                {
                    int tmp = acca;
                    acca -= (accb >> i);
                    accb += (tmp >> i);
                }
            }
            acca >>= 15;
            if (acca > 32767)
            {
                acca = 32767;
            }
            if (acca < -32768)
            {
                acca = -32768;
            }
            return (short)acca;
        }
    }
}
