﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;

namespace SDR
{
    class BinarizationFilter
    {
        // Parameters
        int averageMaxCountBits = 8; // 16ms
        int averageMaxCount = 1 << 8; // 16ms
        int levelDetMaxCount = 64; // Level Det Time = averageCount * levelDetCount, 1.024sec
        int filterCountBits = 3; // Apply Time = levelDetCount * filterCount = 8sec
        int filterCount = 8; // Apply Time = levelDetCount * filterCount = 8sec
        int decisionCount = 320; // 20ms

        // Variables
        int averageCount = 0;
        int accValue = 0;
        int levelDetCount = 0;
        short instMaxLevel = 0;
        short instMinLevel = 32767;
        short maxLevel = 32767;
        short minLevel = 0;
        short centerLevel = 1638; // Assume maximum signal level after AGC is 0.1. 
        int accCenter = 1638 * 8;
        short outValue = 0;
        short nextOutValue = 0;
        int sameValueCount = 319;
        public void SetParam(int averageMaxCount, int levelDetMaxCount, int filterCount, int decisionCount)
        {
            for(this.averageMaxCountBits = 14; this.averageMaxCountBits > 0; this.averageMaxCountBits--)
            {
                if((averageMaxCount & (1 << this.averageMaxCountBits)) > 0)
                {
                    break;
                }
            }
            this.averageMaxCount = 1 << averageMaxCountBits;
            this.levelDetMaxCount = levelDetMaxCount;
            for (this.filterCountBits = 14; this.filterCountBits > 0; this.filterCountBits--)
            {
                if ((filterCount & (1 << this.filterCountBits)) > 0)
                {
                    break;
                }
            }
            this.filterCount = 1 << filterCountBits;
            this.filterCount = filterCount;
            this.decisionCount = decisionCount;

            averageCount = 0;
            accValue = 0;
            levelDetCount = 0;
            instMaxLevel = 0;
            instMinLevel = 32767;
            maxLevel = 32767;
            minLevel = 0;
            centerLevel = 1638; // Assume maximum signal level after AGC is 0.1. 
            accCenter = 1638 * filterCount;
            outValue = 0;
            nextOutValue = 0;
            sameValueCount = decisionCount - 1;
        }

        public void GetParam(out int averageMaxCount, out int levelDetMaxCount, out int filterCount, out int decisionCount)
        {
            averageMaxCount = this.averageMaxCount;
            levelDetMaxCount = this.levelDetMaxCount;
            filterCount = this.filterCount;
            decisionCount = this.decisionCount;
        }
        public void Filter(short[] real, short[] imag, short[] min, short[] max, short[] center)
        {
            for (int i = 0; i < 1024; i++) // the length of real and imag is 1024 
            {
                accValue += real[i];
                averageCount++;
                if (averageCount >= averageMaxCount)
                {
                    short average = (short)(accValue >> averageMaxCountBits);
                    if (average > instMaxLevel) instMaxLevel = average;
                    if (average < instMinLevel) instMinLevel = average;
                    accValue = 0;
                    averageCount = 0;
                    levelDetCount++;
                }
                if (levelDetCount >= levelDetMaxCount)
                {
                    maxLevel = instMaxLevel;
                    minLevel = instMinLevel;
                    short tempCenter = (short)((maxLevel + minLevel) >> 1);
                    accCenter = accCenter - centerLevel + tempCenter;
                    centerLevel = (short)(accCenter >> filterCountBits);

                    instMaxLevel = 0;
                    instMinLevel = 32767;
                    levelDetCount = 0;
                }
                short v = (real[i] >= centerLevel) ? (short)32767 : (short)0;
                if (nextOutValue != v)
                {
                    nextOutValue = v;
                    sameValueCount = 0;
                }
                else if(++sameValueCount >= decisionCount)
                {
                    sameValueCount = 0;
                    outValue = nextOutValue;
                }               
                real[i] = outValue;
                min[i] = minLevel;
                max[i] = maxLevel;
                center[i] = centerLevel;
            }
        }
    }
}
