﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.IO;
using System.IO.Ports;
using System.Runtime.Remoting.Metadata.W3cXsd2001;
using System.Security.Cryptography;
using System.Text;
using System.Windows.Forms;
using static System.Windows.Forms.AxHost;
using static System.Windows.Forms.VisualStyles.VisualStyleElement;

namespace SDR
{
    public partial class JJYForm : Form
    {
        delegate int receiveCodeDelegate(JJYCode code, int value, int count);

        //struct ReceiveStateItem
        //{
        //    public receiveCodeDelegate receiveCode;
        //    public int value;
        //    public int count;
        //};
        public enum JJYCode
        {
            Zero = 0,
            One,
            PosMarker,
            Error
        }

        public enum RcvState
        {
            WaitP0,
            RcvMin,
            RcvHour,
            RcvDays0,
            RcvDays1,
            RcvYear,
            RcvWeekday,
            WaitP0ForFinish,
            WaitP5,
            RcvStopInfo
        }
        public enum RcvError
        {
            None = 0,
            P0,
            Min,
            P1,
            Hour,
            P2,
            Days0,
            Parity,
            ParityCheck,
            SummerTime,
            P3,
            Days1,
            P4,
            Year,
            Weekday,
            LeapSecond,
            P5,
            StopInfo
        }

        RcvState state = RcvState.WaitP0;
        int rcvCount = 0;
        int min;
        int hour;
        int days;
        int parity;
        int summerTime;
        int year;
        int week;
        int leapSecond;
        int stopInfo;
        int mon;
        int day;
        string[] codeStrings = { "0", "1", "P", "E" };
        RcvError rcvErr = RcvError.None;

        public JJYForm()
        {
            InitializeComponent();
        }
        public void UpdateCode(JJYCode code, int lowCount, int highCount)
        {
            if (code >= 0)
            {
                string codeStr = codeStrings[(int)code];
                string lowCountStr = string.Format("{0:F1}ms", lowCount / 16.0);
                string highCountStr = string.Format("{0:F1}ms", highCount / 16.0);
                lowDurationTextBox.Text = lowCountStr;
                highDurationTextBox.Text = highCountStr;
                decodeTextBox.AppendText(codeStr);
                //decodeTextBox.Focus();
                decodeTextBox.SelectionStart = decodeTextBox.Text.Length;
                if (decodeTextBox.Text.Length >= 256) decodeTextBox.Text = decodeTextBox.Text.Substring(1);

                switch (state)
                {
                    case RcvState.WaitP0:
                        waitP0(code);
                        break;
                    case RcvState.RcvMin:
                        receiveMin(code);
                        break;
                    case RcvState.RcvHour:
                        receiveHour(code);
                        break;
                    case RcvState.RcvDays0:
                        receiveDays0(code);
                        break;
                    case RcvState.RcvDays1:
                        receiveDays1(code);
                        break;
                    case RcvState.RcvYear:
                        receiveYear(code);
                        break;
                    case RcvState.RcvWeekday:
                        receiveWeekday(code);
                        break;
                    case RcvState.WaitP5:
                        waitP5(code);
                        break;
                    case RcvState.RcvStopInfo:
                        receiveStopInfo(code);
                        break;
                }

                string stateStr = Enum.GetNames(typeof(RcvState))[(int)state];
                stateTextBox.Text = stateStr;

                logListBox.Items.Add(codeStr + " " + highCount + " " + lowCount + " " + stateStr);
                if (logListBox.Items.Count > 1024) logListBox.Items.RemoveAt(0);
                logListBox.SelectedIndex = logListBox.Items.Count - 1;
            }
        }
        private void waitP0(JJYCode code)
        {
            if (code == JJYCode.PosMarker)
            {
                state = RcvState.RcvMin;
                rcvCount = 0;
                rcvErr = RcvError.None;
            }
            else
            {
                rcvErr = RcvError.None;
            }
        }
        private void receiveMin(JJYCode code)
        {
            if (rcvCount == 0)
            {
                if (code == JJYCode.PosMarker)
                {
                    min = 0;
                    hour = 0;
                    days = 0;
                    parity = 0;
                    summerTime = 0;
                    year = 0;
                    week = 0;
                    leapSecond = 0;
                    stopInfo = 0;

                    rcvCount++;
                }
                else
                {
                    state = RcvState.WaitP0;
                    rcvErr = RcvError.P0;
                }
            }
            else if (rcvCount <= 3)
            {
                if (code <= JJYCode.One)
                {
                    min = (min << 1 | (int)code);
                    rcvCount++;
                }
                else
                {
                    state = RcvState.WaitP0;
                    rcvErr = RcvError.Min;
                }
            }
            else if (rcvCount == 4)
            {
                rcvCount++;
            }
            else if (rcvCount <= 8)
            {
                if (code <= JJYCode.One)
                {
                    min = (min << 1 | (int)code);
                    rcvCount++;
                }
                else
                {
                    state = RcvState.WaitP0;
                    rcvErr = RcvError.Min;
                }
            }
            else
            {
                if (code == JJYCode.PosMarker)
                {
                    state = RcvState.RcvHour;
                    rcvCount = 0;
                }
                else
                {
                    state = RcvState.WaitP0;
                    rcvErr = RcvError.P1;
                }
            }
        }
        private void receiveHour(JJYCode code)
        {
            if (rcvCount <= 1)
            {
                rcvCount++;
            }
            else if (rcvCount <= 3)
            {
                if (code <= JJYCode.One)
                {
                    hour = (hour << 1 | (int)code);
                    rcvCount++;
                }
                else
                {
                    state = RcvState.WaitP0;
                    rcvErr = RcvError.Hour;
                }
            }
            else if (rcvCount == 4)
            {
                rcvCount++;
            }
            else if (rcvCount <= 8)
            {
                if (code <= JJYCode.One)
                {
                    hour = (hour << 1 | (int)code);
                    rcvCount++;
                }
                else
                {
                    state = RcvState.WaitP0;
                    rcvErr = RcvError.Hour;
                }
            }
            else
            {
                if (code == JJYCode.PosMarker)
                {
                    state = RcvState.RcvDays0;
                    rcvCount = 0;
                }
                else
                {
                    state = RcvState.WaitP0;
                    rcvErr = RcvError.P2;
                }
            }
        }
        private void receiveDays0(JJYCode code)
        {
            if (rcvCount <= 1)
            {
                rcvCount++;
            }
            else if (rcvCount <= 3)
            {
                if (code <= JJYCode.One)
                {
                    days = (days << 1 | (int)code);
                    rcvCount++;
                }
                else
                {
                    state = RcvState.WaitP0;
                    rcvErr = RcvError.Days0;
                }
            }
            else if (rcvCount == 4)
            {
                rcvCount++;
            }
            else if (rcvCount <= 8)
            {
                if (code <= JJYCode.One)
                {
                    days = (days << 1 | (int)code);
                    rcvCount++;
                }
                else
                {
                    state = RcvState.WaitP0;
                    rcvErr = RcvError.Days0;
                }
            }
            else
            {
                if (code == JJYCode.PosMarker)
                {
                    state = RcvState.RcvDays1;
                    rcvCount = 0;
                }
                else
                {
                    state = RcvState.WaitP0;
                    rcvErr = RcvError.P3;
                }
            }
        }
        private void receiveDays1(JJYCode code)
        {
            if (rcvCount <= 3)
            {
                if (code <= JJYCode.One)
                {
                    days = (days << 1 | (int)code);
                    rcvCount++;
                }
                else
                {
                    state = RcvState.WaitP0;
                    rcvErr = RcvError.Days1;
                }
            }
            else if (rcvCount <= 5)
            {
                rcvCount++;
            }
            else if (rcvCount == 6)
            {
                if (code <= JJYCode.One)
                {
                    parity = (parity << 1 | (int)code);
                    rcvCount++;
                }
                else
                {
                    state = RcvState.WaitP0;
                    rcvErr = RcvError.Parity;
                }
            }
            else if (rcvCount == 7)
            {
                if (code <= JJYCode.One)
                {
                    parity = (parity << 1 | (int)code);
                    if(CalculateParity() == parity)
                    {
                        rcvCount++;
                    }
                    else
                    {
                        state = RcvState.WaitP0;
                        rcvErr = RcvError.ParityCheck;
                    }
                }
                else
                {
                    state = RcvState.WaitP0;
                    rcvErr = RcvError.Parity;
                }
            }
            else if (rcvCount == 8)
            {
                if (code <= JJYCode.One)
                {
                    summerTime = (summerTime << 1 | (int)code);
                    rcvCount++;
                }
                else
                {
                    state = RcvState.WaitP0;
                    rcvErr = RcvError.SummerTime;
                }
            }
            else
            {
                if (code == JJYCode.PosMarker)
                {
                    if (min == 0x15 || min == 0x45)
                    {
                        state = RcvState.WaitP5;
                        rcvCount = 0;
                    }
                    else
                    {
                        state = RcvState.RcvYear;
                        rcvCount = 0;
                    }
                }
                else
                {
                    state = RcvState.WaitP0;
                    rcvErr = RcvError.P4;
                }
            }
        }
        private void receiveYear(JJYCode code)
        {
            if (rcvCount == 0)
            {
                if (code <= JJYCode.One)
                {
                    summerTime = (summerTime << 1 | (int)code);
                    rcvCount++;
                }
                else
                {
                    state = RcvState.WaitP0;
                    rcvErr = RcvError.SummerTime;
                }
            }
            else if (rcvCount <= 8)
            {
                if (code <= JJYCode.One)
                {
                    year = (year << 1 | (int)code);
                    rcvCount++;
                }
                else
                {
                    state = RcvState.WaitP0;
                    rcvErr = RcvError.Year;
                }
            }
            else
            {
                if (code == JJYCode.PosMarker)
                {
                    if (min == 0x15 || min == 0x45)
                    {
                        state = RcvState.WaitP5;
                        rcvCount = 0;
                    }
                    else
                    {
                        state = RcvState.RcvWeekday;
                        rcvCount = 0;
                    }
                }
                else
                {
                    state = RcvState.WaitP0;
                    rcvErr = RcvError.P4;
                }
            }
        }
        private void receiveWeekday(JJYCode code)
        {
            if (rcvCount <= 2)
            {
                if (code <= JJYCode.One)
                {
                    week = (week << 1 | (int)code);
                    rcvCount++;
                }
                else
                {
                    state = RcvState.WaitP0;
                    rcvErr = RcvError.Weekday;
                }
            }
            else if (rcvCount <= 4)
            {
                if (code <= JJYCode.One)
                {
                    leapSecond = (leapSecond << 1 | (int)code);
                    rcvCount++;
                }
                else
                {
                    state = RcvState.WaitP0;
                    rcvErr = RcvError.LeapSecond;
                }
            }
            else if (rcvCount <= 8)
            {
                rcvCount++;
            }
            else if (rcvCount == 9)
            {
                if (code == JJYCode.PosMarker)
                {
                    state = RcvState.RcvMin;
                    rcvCount = 0;
                    displayTime();
                }
            }
            else
            {
                if (code == JJYCode.PosMarker)
                {
                    state = RcvState.RcvMin;
                    rcvCount = 0;
                    displayTime();
                }
                else
                {
                    state = RcvState.WaitP0;
                    rcvErr = RcvError.P0;
                }
            }
        }
        private void waitP5(JJYCode code)
        {
            if (code == JJYCode.PosMarker)
            {
                state = RcvState.RcvStopInfo;
                rcvCount = 0;
            }
        }
        private void receiveStopInfo(JJYCode code)
        {
            if (rcvCount <= 5)
            {
                if (code <= JJYCode.One)
                {
                    stopInfo = (stopInfo << 1 | (int)code);
                    rcvCount++;
                }
                else
                {
                    state = RcvState.WaitP0;
                    rcvErr = RcvError.StopInfo;
                }
            }
            else if (rcvCount <= 8)
            {
                rcvCount++;
            }
            else
            {
                if (code == JJYCode.PosMarker)
                {
                    state = RcvState.RcvMin;
                    rcvCount = 0;
                }
                else
                {
                    state = RcvState.WaitP0;
                    rcvErr = RcvError.P0;
                }
            }
        }
        private int CalculateParity()
        {
            int calcParity;
            int sum = 0;
            for (int i = 5; i >= 0; i--)
            {
                sum += ((hour >> i) & 1);
            }
            calcParity = ((sum & 1) << 1);
            sum = 0;
            for (int i = 6; i >= 0; i--)
            {
                sum += ((min >> i) & 1);
            }
            calcParity |= (sum & 1);

            return calcParity;
        }
        private void displayTime()
        {
            minTextBox.Text = string.Format("{0:X2}", min);
            hourTextBox.Text = string.Format("{0:X2}", hour);
            daysTextBox.Text = string.Format("{0:X3}", days);
            yearTextBox.Text = string.Format("{0:X2}", year);
            parityTextBox.Text = string.Format("{0:X2}", parity);
            suTextBox.Text = string.Format("{0:X2}", summerTime);
            weekTextBox.Text = string.Format("{0:X2}", week);
            lsTextBox.Text = string.Format("{0:X2}", leapSecond);
            stTextBox.Text = string.Format("{0:X2}", stopInfo);
            DaysToMonDay();
            timeTextBox.Text = string.Format("{0:X2}/{1:X2}/{2:X2} {3:X2}:{4:X2}",
                new object[] { year, mon, day, hour, min });
        }
        private int SubtractBCD(int v0, int v1)
        {
            int rv = 0;
            int b = 0;
            for(int i = 0; i < 12; i += 4)
            {
                int v = (v0 & 0xf) - (v1 & 0xf) - b;
                if(v < 0)
                {
                    rv += (0x10 + v) << i;
                    b = 1;
                }
                else
                {
                    rv += v << i;
                    b = 0;
                }
                v0 >>= 4;
                v1 >>= 4;
            }
            return rv;
        }
        private void DaysToMonDay()
        {
            int[] monTable = ((year & 3) == 0) ?
                new int[]
                {
                    0x335, 0x305, 0x274, 0x244, 0x213, 0x182, 0x152, 0x121, 0x91, 0x60, 0x31
                } :
                new int[]
                {
                    0x334, 0x304, 0x273, 0x243, 0x212, 0x181, 0x151, 0x120, 0x90, 0x59, 0x31
                };
            int i;
            for (i = 0; i < monTable.Length; i++)
            {
                if (days > monTable[i])
                {
                    mon = 12 - i;
                    if (mon >= 10) mon += 6; // 10th digit BCD
                    day = SubtractBCD(days, monTable[i]);
                    break;
                }
            }
            if(i >= monTable.Length)
            {
                mon = 1;
                day = days;
            }
        }
        private void copyCodesButton_Click(object sender, EventArgs e)
        {
            Clipboard.SetText(decodeTextBox.Text);
        }
        private void copyLogsButton_Click(object sender, EventArgs e)
        {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < logListBox.Items.Count; i++)
            {
                sb.AppendLine(logListBox.Items[i].ToString());
            }
            Clipboard.SetText(sb.ToString());
        }

        private void clearButton_Click(object sender, EventArgs e)
        {
            decodeTextBox.Text = "";
            logListBox.Items.Clear();
            minTextBox.Text = "";
            hourTextBox.Text = "";
            daysTextBox.Text = "";
            yearTextBox.Text = "";
            parityTextBox.Text = "";
            suTextBox.Text = "";
            weekTextBox.Text = "";
            lsTextBox.Text = "";
            stTextBox.Text = "";
            timeTextBox.Text = "";
        }

        private void JJYForm_FormClosing(object sender, FormClosingEventArgs e)
        {
            e.Cancel = true;
        }
    }
}
