﻿using System;
using System.Collections.Generic;
using System.Drawing.Printing;
using System.Text;

namespace SDR
{
    class JjyDecoder
    {
        int lowCount;
        int highCount;
        int prevValue;
        int margin;

        public JjyDecoder()
        {
            lowCount = -1;
            highCount = -1;
            prevValue = 0;
            margin = 16 * 100; // 40ms
        }
        public int Decode(double[] real, out int lowCount_, out int highCount_)
        {
            int code = -1;
            lowCount_ = 0;
            highCount_ = 0;
            for (int i = 0; i < 1024; i++)
            {
                int curValue = (real[i] > 16339) ? 1 : 0;
                if (prevValue != curValue)
                {
                    if (highCount >= 1 && curValue == 1)
                    {
                        if(lowCount > 1)
                        {
                            if ((16000 - margin) <= (lowCount + highCount) &&
                                (lowCount + highCount) <= (16000 + margin))
                            {
                                if((16 * 200 - margin) <= highCount && highCount <= (16 * 200 + margin))
                                {
                                    code = 2;
                                }
                                else if ((16 * 500 - margin) <= highCount && highCount <= (16 * 500 + margin))
                                {
                                    code = 1;
                                }
                                else if ((16 * 800 - margin) <= highCount && highCount <= (16 * 800 + margin))
                                {
                                    code = 0;
                                }
                                else
                                {
                                    code = 3;
                                }
                            }
                            else
                            {
                                code = 3;
                            }
                            lowCount_ = lowCount;
                            highCount_ = highCount;
                        }
                        highCount = 1;
                        lowCount = -1;
                    }
                    else
                    {
                        lowCount = 0;
                    }
                    prevValue = curValue;
                }
                else
                {
                    if (curValue == 1)
                    {
                        highCount++;
                    }
                    else
                    {
                        lowCount++;
                    }
                }
            }

            return code;
        }
    }
}
