﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;

namespace SDR
{
    class BinarizationFilter
    {
        // Parameters
        int averageMaxCount = 320; // 20ms
        int levelDetMaxCount = 50; // Level Det Time = averageCount * levelDetCount = 1sec
        int filterCount = 8; // Apply Time = levelDetCount * filterCount = 8sec
        int decisionCount = 320; // 20ms

        // Variables
        int averageCount = 0;
        double accValue = 0;
        int levelDetCount = 0;
        double instMaxLevel = 0;
        double instMinLevel = double.MaxValue;
        double maxLevel = 1.0;
        double minLevel = 0;
        double centerLevel = 0.05; // Assume maximum signal level after AGC is 0.1. 
        double accCenter = 0.05 * 8;
        double outValue = 0;
        double nextOutValue = 0;
        int sameValueCount = 319;
        public void SetParam(int averageMaxCount, int levelDetMaxCount, int filterCount, int decisionCount)
        {
            this.averageMaxCount = averageMaxCount;
            this.levelDetMaxCount = levelDetMaxCount;
            this.filterCount = filterCount;
            this.decisionCount = decisionCount;

            averageCount = 0;
            accValue = 0;
            levelDetCount = 0;
            instMaxLevel = 0;
            instMinLevel = double.MaxValue;
            maxLevel = 1.0;
            minLevel = 0;
            centerLevel = 0.05; // Assume maximum signal level after AGC is 0.1. 
            accCenter = 0.05 * filterCount;
            outValue = 0;
            nextOutValue = 0;
            sameValueCount = decisionCount - 1;
        }

        public void GetParam(out int averageMaxCount, out int levelDetMaxCount, out int filterCount, out int decisionCount)
        {
            averageMaxCount = this.averageMaxCount;
            levelDetMaxCount = this.levelDetMaxCount;
            filterCount = this.filterCount;
            decisionCount = this.decisionCount;
        }
        public void Filter(double[] real, double[] imag, double[] min, double[] max, double[] center)
        {
            for (int i = 0; i < 1024; i++) // the length of real and imag is 1024 
            {
                accValue += real[i];
                averageCount++;
                if (averageCount >= averageMaxCount)
                {
                    double average = accValue / averageMaxCount;
                    if (average > instMaxLevel) instMaxLevel = average;
                    if (average < instMinLevel) instMinLevel = average;
                    accValue = 0;
                    averageCount = 0;
                    levelDetCount++;
                }
                if (levelDetCount >= levelDetMaxCount)
                {
                    maxLevel = instMaxLevel;
                    minLevel = instMinLevel;
                    double tempCenter = (maxLevel + minLevel) / 2;
                    accCenter = accCenter - centerLevel + tempCenter;
                    centerLevel = accCenter / filterCount;

                    instMaxLevel = 0;
                    instMinLevel = double.MaxValue;
                    levelDetCount = 0;
                }
                double detLevel = (outValue == 0) ? centerLevel * 1.0 : centerLevel * 1.0;
                double v = (real[i] >= detLevel) ? 32767 : 0;
                if (nextOutValue != v)
                {
                    nextOutValue = v;
                    sameValueCount = 0;
                }
                else if(++sameValueCount >= decisionCount)
                {
                    sameValueCount = 0;
                    outValue = nextOutValue;
                }               
                real[i] = outValue;
                min[i] = minLevel;
                max[i] = maxLevel;
                center[i] = centerLevel;
            }
        }
    }
}
